(* C:\Users\barba\Documents\Ocaml\examples *)

class point =
    object (self:'self)
      val mutable x = 0
      val mutable y = 0
      method get_x = x
      method get_y = y
      method setcoord new_x new_y = x <- new_x ; y<- new_y
    end;;

(* Definition of a class point whose state is made of
two coordinates. Ocaml is a functional languages where
we have also imperative and o.o. features. Here the two coordinates
are defined as "mutable" since are variables in the sense of
imperative programming.
The method setcoord modifies such variables.
x<- new_x is an assignment
Ocaml is a strognly typed language, where types are
inferred. 
The type system is very similar to the one of Haskell,
with the same sort of polymorphism (type variables
are called 'a,'b, etc).
As in Haskell, when ocaml is started, we can interact with
the interpreter, giving to it expressions to evaluate,
or definitions as the one above.

The notation "(self:'self)" means that in the class
definition we can refer to the object to which the
method is sent using the name "self" (we could choose
also a different name) and we can refer to its type 
as "'self".
*)



class colorPoint =
    object (self:'self)
      inherit point as super
      val mutable color = "white"
      method get_color = color
      method setcolor new_color = color<- new_color
      method set new_x new_y new_color =
                              super#setcoord new_x new_y;
                              self#setcolor new_color
    end;;

(* colorPoint is a subclass of point.
Here we inherit all fields and method of point.
The keyword "as super" means that we can invoke
the methods of point using super to refer to the 
method of the superclass.
See hao we can have reuse of code in the method set
which has three parameters that we use to modify
all the fields of a color point.
In Ocaml there is a structural approach to typing.
The type of an object is precisely the type
used by Bruce in is textbook.
We can override inherited methods, but we cannot change 
the type of input and output type, like in Java.
However, later on we shall see that this does not
cause problems with binary methods. 
*)

(*

let mypoint = new point;;

-Here we create a new point, naming it "mypoint"-


mypoint#setcoord 3 4;;

mypoint#get_y;;

let mypoint2 = new point;;

let mycpoint = new colorPoint;;

mycpoint#set 6 7 "red";;

mycpoint#get_color;;

let mycpoint2 = new colorPoint;;

let sameplace p1 p2 = p1#get_x=p2#get_x && p1#get_y=p2#get_y;;

- we have just defined a function "sameplace" checking
- whether two points have the same coordinates
- check on the interpreter the type inferred for this function.
- You see, the type inferred is the most general one.
- It is enough p1 and p2 have an object type with the
- methods get_x and get_y.

let sameplacep (p1:point) (p2:point) = sameplace p1 p2;;

- We have now restricted the function to have as
- input only objects of class point.

sameplacep mypoint mypoint2;;


- The notion of subtyping in Ocaml is the correct one
- we have studied for record types in typed lambda-calculus
- (also described in Bruce's textbook)
- an object of colorPoint has a type which is subtype
- of the objects of point.

sameplacep mycpoint mycpoint2;;

- This application does not work, since
- an object of a subtype is not automatically
- converted in an object of the supertype 
- The conversion (called "coercion") has to be
- explicitely made, as in the following.

sameplacep (mycpoint:>point) (mycpoint2:>point);;

- Object can be created also without using a class

let myStrangeP = object 
        val mutable x = 0
        val mutable y = 0
        method get_x = 3
        method get_y = 4
        method setcoord new_x new_y = x <- new_x +1 ; y<- new_y +2
        end;;

- We have just created an object (we have called it
- myStrangeP) whose type is structurally the same as
- the type of objects of class point


let f (p:point) = p#setcoord 1 2;;

- f is a function that we have specified to take
- element of type point as input

f myStrangeP;;

- We can saferly apply f to myStrangeP because
- its type is the same as point

*)


class pointEq =
    object (self:'self)
      inherit point as super
      method equal (p2:'self) = super#get_x=p2#get_x && super#get_y=p2#get_y
    end;;

(*
We have created a subclass of point adding a binary method.
Look at the type of objects of class point:
the type variable 'a is used to refer to the type of
the object. 
In practice, we can look at the type of objects of class
pointEq as it were of the form

('a)< get_x : int; get_y : int; setcoord : int -> int -> unit; equal : 'a -> bool >

 where in  'a -> bool the name 'a stands for the whole object type itself.


This mechanism enables to overcome the problems
with binary methods inherited in subclasses.
*)

class colorPointEq =
    object (self:'self)
      inherit pointEq as super
      val mutable color = "white"
      method get_color = color
      method setcolor new_color = color<- new_color
      method set new_x new_y new_color =
                              super#setcoord new_x new_y;
                              self#setcolor new_color
      method equal (p2:'self) = super#equal p2 && self#get_color = p2#get_color
    end;;

(* See the type of colorPointEq. Now the type variable 'a
is used to refer to the type of colorPointEq objects.
So, by forcing, in equal, p2 to have the type 'self,
we do not have anymore the problems we have with overridden
binary methods.

In Ocaml subclasses do not necessarily define subtypes.
In fact, the method equal in pointEq has type 'a -> Bool,
but the 'a stands for the type of pointEq objects.
In colorPointEq the method equal has also type 'a -> Bool,
but the 'a refers to the type of colorPointEq objects.
Notice that 'a is in contravariant position.
So, the type of equal in pointEq can be a supertype 
of the one in colorPointEq only if the type of
pointEq objects be a subtype of the type of colorPointEq objects.
And this is impossible.
*)


(*
This example show that in Ocaml input and output types
of overridden methods must be the same (except for types 'a).

class c =
    object (self:'self)
            method m (p:colorPoint) = new point
            
    end;; 

class subc =
        object (self:'self)
                inherit c
                method m (p: point) = new point     !!theorically possible but NOT ALLOWED !!!!!
                end;;

class subc2 =
    object (self:'self)
            method m (p:colorPoint) = new colorPoint  !!theorically possible but NOT ALLOWED !!!!!
            
    end;; 

*)


